﻿<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="keywords" content="" />
        <meta name="author" content="" />
        <meta name="robots" content="" />
        <!-- PAGE TITLE HERE -->
        <title>Compression Spring | Sainik Springs</title>
		<!-- FAVICONS ICON -->
        <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png" />

        <!-- MOBILE SPECIFIC -->
        <meta name="viewport" content="width=device-width, initial-scale=1" />

		<?php $page='products'; include 'head.php'; ?>
    </head>
    <body id="bg">
        <div class="page-wraper">
            <!-- header -->
			<?php include 'header.php'; ?>	
            <!-- Content -->
            <div class="page-content bg-white">
                <!-- inner page banner -->
                <div
                    class="dlab-bnr-inr overlay-black-middle text-center bg-pt"
                    style="background-image: url(images/banner/page-banner.jpg)"
                >
                    <div class="container">
                        <div class="dlab-bnr-inr-entry align-m text-center">
                            <h1 class="text-white">Compression Spring</h1>
                            <!-- Breadcrumb row -->
                            <div class="breadcrumb-row">
                                <ul class="list-inline">
                                    <li><a href="index">Home</a></li>
                                    <li><a href="javascript:;">Products</a></li>
                                    <li>Compression Spring</li>
                                </ul>
                            </div>
                            <!-- Breadcrumb row END -->
                        </div>
                    </div>
                </div>
				
                <!-- contact area -->
                <div class="section-full content-inner bg-white">
                    <!-- Product details -->
                    <div class="container woo-entry">
                        <div class="row m-b30">
                            <div class="col-md-5 col-lg-5 col-sm-12">
                                <div class="product-gallery on-show-slider lightgallery" id="lightgallery">
                                    <div
                                        id="sync1"
                                        class="owl-carousel owl-theme owl-btn-center-lr m-b5 owl-btn-1 primary"
                                    >
                                        <div class="item">
                                            <div class="mfp-gallery">
                                                <div class="dlab-box">
                                                    <div class="dlab-thum-bx">
                                                        <img src="images/product/compression-spring.jpg" alt="" />
                                                        <div class="overlay-bx">
                                                            <div class="overlay-icon">
                                                                <span
                                                                    data-exthumbimage="images/product/compression-spring.jpg"
                                                                    data-src="images/product/compression-spring.jpg"
                                                                    class="check-km"
                                                                    title=""
                                                                >
                                                                    <i class="ti-fullscreen"></i>
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									</div>
								</div>
                            </div>
                            <div class="col-md-7 col-lg-7 col-sm-12">
                                <form method="post" class="cart sticky-top">
                                    <div class="dlab-post-title">
										<h2 class="m-b15 title">
                                            Compression <b>Spring</b>
                                        </h2>
                                        <p>
                                            Compression Springs are designed to keep two things apart. Their job is to prevent two objectsfrom meeting. These springs bear the bulk load that presses the parts they join. When pressure is applied to the first part, it passes the pressure to the spring, which becomes short under pressure and pushes the first part back to its original.
                                        </p>
                                        <p class="m-b10">
                                            Compression Springs become more compact compression springs end types might be normal or customized standard ends can be open or closed it may be closed ends, ground ends, Double closed that’s open end.
                                        </p>
                                        <div class="dlab-divider bg-gray tb15">
                                            <i class="icon-dot c-square"></i>
                                        </div>
                                    </div>
									<a href="#" class="site-button radius-no">
                                        Request a Quote <i class="far fa-envelope"></i>
                                    </a>
                                </form>
                            </div>
                        </div>
					</div>
                    <!-- Product details -->
                </div>
                <!-- contact area  END -->
			</div>
            <!-- Content END-->
            <!-- Footer -->
				<?php include 'footer.php'; ?>
			<!-- Footer End -->
            <button class="scroltop fas fa-chevron-up"></button>
        </div>
        
			<?php include 'footer-link-files.php'; ?>
			
        <script>
            $(document).ready(function () {
                var sync1 = $("#sync1");
                var sync2 = $("#sync2");
                var slidesPerPage = 4; //globaly define number of elements per page
                var syncedSecondary = true;

                sync1
                    .owlCarousel({
                        items: 1,
                        slideSpeed: 2000,
                        nav: true,
                        autoplay: false,
                        dots: false,
                        loop: true,
                        responsiveRefreshRate: 200,
                        navText: ['<i class="fas fa-chevron-left"></i>', '<i class="fas fa-chevron-right"></i>'],
                    })
                    .on("changed.owl.carousel", syncPosition);

                sync2
                    .on("initialized.owl.carousel", function () {
                        sync2.find(".owl-item").eq(0).addClass("current");
                    })
                    .owlCarousel({
                        items: slidesPerPage,
                        dots: false,
                        nav: false,
                        margin: 5,
                        smartSpeed: 200,
                        slideSpeed: 500,
                        slideBy: slidesPerPage, //alternatively you can slide by 1, this way the active slide will stick to the first item in the second carousel
                        responsiveRefreshRate: 100,
                    })
                    .on("changed.owl.carousel", syncPosition2);

                function syncPosition(el) {
                    //if you set loop to false, you have to restore this next line
                    //var current = el.item.index;

                    //if you disable loop you have to comment this block
                    var count = el.item.count - 1;
                    var current = Math.round(el.item.index - el.item.count / 2 - 0.5);

                    if (current < 0) {
                        current = count;
                    }
                    if (current > count) {
                        current = 0;
                    }

                    //end block

                    sync2.find(".owl-item").removeClass("current").eq(current).addClass("current");
                    var onscreen = sync2.find(".owl-item.active").length - 1;
                    var start = sync2.find(".owl-item.active").first().index();
                    var end = sync2.find(".owl-item.active").last().index();

                    if (current > end) {
                        sync2.data("owl.carousel").to(current, 100, true);
                    }
                    if (current < start) {
                        sync2.data("owl.carousel").to(current - onscreen, 100, true);
                    }
                }

                function syncPosition2(el) {
                    if (syncedSecondary) {
                        var number = el.item.index;
                        sync1.data("owl.carousel").to(number, 100, true);
                    }
                }

                sync2.on("click", ".owl-item", function (e) {
                    e.preventDefault();
                    var number = $(this).index();
                    //sync1.data('owl.carousel').to(number, 300, true);

                    sync1.data("owl.carousel").to(number, 300, true);
                });
            });
        </script>
    </body>
</html>
